//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define def_NameHLine		m_Info.szPrefixName + "#HLINE"
#define def_NameBtnClose	m_Info.szPrefixName + "#CLOSE"
#define def_NameBtnMove		m_Info.szPrefixName + "#MOVE"
#define def_NameInfoDirect	m_Info.szPrefixName + "#DIRECT"
#define def_NameObjLabel	m_Info.szPrefixName + "#PROFIT"
#define def_NameBackGround m_Info.szPrefixName + "#BACKGROUND"
#define def_NameVolume		m_Info.szPrefixName + "#VOLUME"
//+------------------------------------------------------------------+
#define def_GhostColor		clrDarkGray
#define macro_GhostName(A) (m_Info.szPrefixName + "[GHOST]" + (A != "" ? StringSubstr(A, StringFind(A, "#")) : ""))
//+------------------------------------------------------------------+
#define macro_LineInFocus(A) ObjectSetInteger(0, def_NameHLine, OBJPROP_YSIZE, m_Info.weight = (A ? 3 : 1));
//+------------------------------------------------------------------+
#define def_PathBtns "Images\\Market Replay\\Orders\\"
#define def_Btn_Close def_PathBtns + "Btn_Close.bmp"
#resource "\\" + def_Btn_Close;
//+------------------------------------------------------------------+
#include "..\Auxiliar\C_Mouse.mqh"
//+------------------------------------------------------------------+
#ifdef def_FontName
	"Why are you trying to do this?"
#else 
	#define def_FontName "Lucida Console"
	#define def_FontSize 10
#endif 
//+------------------------------------------------------------------+
class C_ElementsTrade : private C_Mouse
{
	private	:
//+------------------------------------------------------------------+
		struct stInfos
		{
			struct st_01
			{
				short		Width,
							Height,
							digits;
			}Text;
			ulong			ticket;
			string 		szPrefixName,
							szDescr,
							szSymbol,
							szMsgGhost;
			EnumEvents 	ev;
			double		price,
							open,
							volume,
							var,
							tickSize,
							tpsl,
							limit,
							priceGhost;
			bool			bClick,
			            bIsBuy;
			char			weight;
			color			_color;
			int			sizeText;
			enum e1 {eValue, eFinance, eTicks, ePercentage} ViewMode;
		}m_Info;
//+------------------------------------------------------------------+
		short UpdateViewPort(const double price, short size = 0, uint ui = 0)
		{
#define macro_Local(A) {																																																	\
			ChartTimePriceToXY(0, 0, 0, (A ? price : m_Info.priceGhost), x, y);																																\
			x = 125 + (m_Info.ev == evMsgClosePositionEA ? 0 : _Width + (m_Info.ev == evMsgCloseTakeProfit ? _SizeControls : (_SizeControls * 2)));									\
			ObjectSetInteger(0, (A ? def_NameHLine : macro_GhostName(def_NameHLine)), OBJPROP_XDISTANCE, x);																						\
			ObjectSetInteger(0, (A ? def_NameHLine : macro_GhostName(def_NameHLine)), OBJPROP_YDISTANCE, y - (m_Info.weight > 1 ? (int)(m_Info.weight / 2) : 0));					\
			ObjectSetInteger(0, (A ? def_NameObjLabel : macro_GhostName(def_NameObjLabel)), OBJPROP_XDISTANCE, x + 10 + (m_Info.ev == evMsgClosePositionEA ? _Width + 2 : 0));\
			ObjectSetInteger(0, (A ? def_NameObjLabel : macro_GhostName(def_NameObjLabel)), OBJPROP_YDISTANCE, y - (m_Info.Text.Height / 2));											\
			ObjectSetInteger(0, (A ? def_NameBtnMove : macro_GhostName(def_NameBtnMove)), OBJPROP_XDISTANCE, x + _Width + 20);																\
			ObjectSetInteger(0, (A ? def_NameBtnMove : macro_GhostName(def_NameBtnMove)), OBJPROP_YDISTANCE, y);																					\
			ObjectSetInteger(0, (A ? def_NameBackGround : macro_GhostName(def_NameBackGround)), OBJPROP_XDISTANCE, x - 10);																	\
			ObjectSetInteger(0, (A ? def_NameBackGround : macro_GhostName(def_NameBackGround)), OBJPROP_YDISTANCE, y - ((m_Info.Text.Height + 5) / 2)); }		

			static short _SizeControls;
			static short _Width;
			uint x, y;
			
			if (size > 0)
			{
				size += (short)(ui + 8);
				_SizeControls = (_SizeControls > size ? _SizeControls : size);
				size = (short)(_SizeControls - ui - 12);
				_Width = (_Width > size ? _Width : size);
			}else
			{
				macro_Local(true);
				ObjectSetInteger(0, def_NameVolume, OBJPROP_XDISTANCE, x + 10);
				ObjectSetInteger(0, def_NameVolume, OBJPROP_YDISTANCE, y - (m_Info.Text.Height / 2));
				ObjectSetInteger(0, def_NameBtnClose, OBJPROP_XDISTANCE, x);
				ObjectSetInteger(0, def_NameBtnClose, OBJPROP_YDISTANCE, y);
				ObjectSetInteger(0, def_NameInfoDirect, OBJPROP_XDISTANCE, x + (_Width * 2) + 20);
				ObjectSetInteger(0, def_NameInfoDirect, OBJPROP_YDISTANCE, y);
				if (m_Info.szMsgGhost != "")
					macro_Local(false)
			}
			return _Width;
#undef macro_Local
		}
//+------------------------------------------------------------------+
inline void CreateLinePrice(void)
		{
#define macro_Local(A)																															\
			CreateObjectGraphics(szObj = A, OBJ_RECTANGLE_LABEL, m_Info._color, (EnumPriority)(ePriorityDefault));	\
			ObjectSetInteger(0, A, OBJPROP_BGCOLOR, m_Info._color);																	\
			ObjectSetInteger(0, A, OBJPROP_BORDER_TYPE, BORDER_FLAT);																\
			ObjectSetInteger(0, A, OBJPROP_CORNER, CORNER_LEFT_UPPER);

			string szObj;
			
			macro_Local(def_NameHLine);
			ObjectSetInteger(0, szObj, OBJPROP_XSIZE, TerminalInfoInteger(TERMINAL_SCREEN_WIDTH));
			ObjectSetString(0, szObj, OBJPROP_TOOLTIP, m_Info.szDescr);
			macro_LineInFocus(false);
			macro_Local(def_NameBackGround);
#undef macro_Local			
		}
//+------------------------------------------------------------------+
inline void CreateBoxInfo(const bool bMove)
		{
			string szObj;
			const char c[] = {(char)(bMove ? 'u' : (m_Info.bIsBuy ? 236 : 238)), 0};
			
			CreateObjectGraphics(szObj = (bMove ? def_NameBtnMove : def_NameInfoDirect), OBJ_LABEL, clrNONE, (EnumPriority)(ePriorityDefault));
			ObjectSetString(0, szObj, OBJPROP_FONT, "Wingdings");
			ObjectSetString(0, szObj, OBJPROP_TEXT, CharArrayToString(c));
			ObjectSetInteger(0, szObj, OBJPROP_COLOR, (bMove ? (m_Info.ev == evMsgCloseTakeProfit ? clrDarkGreen : clrMaroon) : (m_Info.bIsBuy ? clrDarkGreen : clrMaroon)));
			ObjectSetInteger(0, szObj, OBJPROP_FONTSIZE, (bMove ? 17 : 15));
			ObjectSetInteger(0, szObj, OBJPROP_ANCHOR, ANCHOR_CENTER);
		}
//+------------------------------------------------------------------+
inline void CreateObjectInfoText(const string szObj, const color _color)
		{
			CreateObjectGraphics(szObj, OBJ_EDIT, clrNONE, (EnumPriority)(ePriorityDefault));
			ObjectSetString(0, szObj, OBJPROP_FONT, def_FontName);
			ObjectSetInteger(0, szObj, OBJPROP_FONTSIZE, def_FontSize);
			ObjectSetInteger(0, szObj,	OBJPROP_COLOR, clrBlack);
			ObjectSetInteger(0, szObj, OBJPROP_BORDER_COLOR, _color);
			ObjectSetInteger(0, szObj, OBJPROP_ALIGN, ALIGN_CENTER);
			ObjectSetInteger(0, szObj, OBJPROP_READONLY, true);
		}
//+------------------------------------------------------------------+
inline void CreateButtonClose(void)
		{
			string szObj;
			
			CreateObjectGraphics(szObj = def_NameBtnClose, OBJ_BITMAP_LABEL, clrNONE, (EnumPriority)(ePriorityDefault));
			ObjectSetString(0, szObj, OBJPROP_BMPFILE, 0, "::" + def_Btn_Close);
			ObjectSetInteger(0, szObj, OBJPROP_ANCHOR, ANCHOR_CENTER);
		}
//+------------------------------------------------------------------+
inline void AdjustDinamic(const string szObj, const string szTxt)
		{
#define macro_Local(A) \
			ObjectSetInteger(0, A, OBJPROP_XSIZE, m_Info.Text.Width + h + (m_Info.ev == evMsgClosePositionEA ? m_Info.Text.Width + 8 : 0)); \
			ObjectSetInteger(0, A, OBJPROP_YSIZE, m_Info.Text.Height + 5);

			uint w, h;

			TextSetFont(def_FontName, def_FontSize * -10);
			TextGetSize(szTxt, w, h);
			m_Info.Text.Height = (uchar) h + 4;
			m_Info.Text.Width = (uchar) w + 4;
			m_Info.Text.Width = UpdateViewPort(0, m_Info.Text.Width, h = 32);
			ObjectSetInteger(0, szObj, OBJPROP_XSIZE, m_Info.Text.Width);
			ObjectSetInteger(0, szObj, OBJPROP_YSIZE, m_Info.Text.Height);
			macro_Local(def_NameBackGround);
			if (m_Info.szMsgGhost != "")
			{
				macro_Local(macro_GhostName(def_NameBackGround));
				ObjectSetString(0, macro_GhostName(def_NameObjLabel), OBJPROP_TEXT, m_Info.szMsgGhost);
			}
#undef macro_Local
		}
//+------------------------------------------------------------------+
inline void ChartChange(void)
		{
			UpdateViewPort(MathAbs(m_Info.price));
			m_Info.limit = (m_Info.bIsBuy ? m_Info.price - m_Info.open : m_Info.open - m_Info.price);
			if (m_Info.ev != evMsgClosePositionEA)
				ViewValue(m_Info.limit);
		}
//+------------------------------------------------------------------+
		void CreateGhost(void)
		{
			ObjectSetInteger(0, def_NameHLine, OBJPROP_BGCOLOR, def_GhostColor);
			ObjectSetInteger(0, def_NameHLine, OBJPROP_COLOR, def_GhostColor);
			ObjectSetInteger(0, def_NameObjLabel, OBJPROP_BGCOLOR, def_GhostColor);
			ObjectSetInteger(0, def_NameObjLabel, OBJPROP_BORDER_COLOR, def_GhostColor);
			ObjectSetInteger(0, def_NameBtnMove, OBJPROP_COLOR, def_GhostColor);
			ObjectSetInteger(0, def_NameBackGround, OBJPROP_BGCOLOR, def_GhostColor);
			ObjectSetInteger(0, def_NameBackGround, OBJPROP_COLOR, def_GhostColor);			
			ObjectSetString(0, def_NameHLine, OBJPROP_NAME, macro_GhostName(def_NameHLine));
			ObjectSetString(0, def_NameBtnMove, OBJPROP_NAME, macro_GhostName(def_NameBtnMove));
			ObjectSetString(0, def_NameObjLabel, OBJPROP_NAME, macro_GhostName(def_NameObjLabel));
			ObjectSetString(0, def_NameBackGround, OBJPROP_NAME, macro_GhostName(def_NameBackGround));
			m_Info.priceGhost = MathAbs(m_Info.price);
			m_Info.szMsgGhost = "";
		}
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_ElementsTrade(const ulong ticket, string szSymbol, const EnumEvents ev, color _color, char digits, double ticksize, string szDescr = "\n", const bool IsBuy = true)
			:C_Mouse(0, "")
		{
			ZeroMemory(m_Info);
			m_Info.szPrefixName = StringFormat("%I64u@%03d", m_Info.ticket = ticket, (int)(m_Info.ev = ev));
			m_Info._color = _color;
			m_Info.szDescr = szDescr;
			m_Info.bIsBuy = IsBuy;
			m_Info.Text.digits = digits;
			m_Info.tickSize = ticksize;
			m_Info.szSymbol = szSymbol;
		}
//+------------------------------------------------------------------+
		~C_ElementsTrade()
		{
			ChartSetInteger(0, CHART_EVENT_OBJECT_DELETE, false);
			ObjectsDeleteAll(0, m_Info.szPrefixName);
			ChartSetInteger(0, CHART_EVENT_OBJECT_DELETE, true);
		}
//+------------------------------------------------------------------+
inline void UpdatePrice(const double open, const double price, const double vol = 0, const double var = 0, const double special = -1)
		{
			m_Info.sizeText = 0;
			ChartSetInteger(0, CHART_EVENT_OBJECT_DELETE, false);
			ObjectsDeleteAll(0, m_Info.szPrefixName + "#");
			ChartSetInteger(0, CHART_EVENT_OBJECT_DELETE, true);
			m_Info.volume = (vol > 0 ? vol : m_Info.volume);
			m_Info.var = (var > 0 ? var : m_Info.var);
			m_Info.tpsl = (special >= 0 ? special : m_Info.tpsl);
			if (price > 0)
			{
				CreateLinePrice();
				CreateButtonClose();
				CreateObjectInfoText(def_NameObjLabel, m_Info._color);
			}
			CreateBoxInfo(m_Info.ev != evMsgClosePositionEA);
			m_Info.open = open;
			m_Info.price = (price > 0 ? price : -open);
			if (m_Info.ev == evMsgClosePositionEA)
			{
				CreateObjectInfoText(def_NameVolume, clrBlack);
				ObjectSetInteger(0, def_NameVolume, OBJPROP_BGCOLOR, clrViolet);				
				ObjectSetString(0, def_NameVolume, OBJPROP_TEXT, DoubleToString(m_Info.volume, (MathRound(m_Info.volume) != m_Info.volume ? 2 : 0)));
				AdjustDinamic(def_NameVolume, "88888" + (MathRound(m_Info.volume) != m_Info.volume ? ".88" : ""));
			};
			ChartChange();
		}
//+------------------------------------------------------------------+
		void ViewValue(const double profit, const bool Enabled = true)
		{
			string szTxt;
			color  _cor;
			static double memSL, memTP;
			
			if (Enabled)
			{
				switch (m_Info.ViewMode)
				{
					case stInfos::eValue:
						szTxt = StringFormat("%." + (string)m_Info.Text.digits + "f", MathAbs(profit));
						break;
					case stInfos::eFinance:
						szTxt = StringFormat("$ %." + (string)m_Info.Text.digits + "f", (MathAbs(profit) / m_Info.var) * m_Info.volume);
						break;
					case stInfos::eTicks:
						szTxt = StringFormat("%d", (uint)MathRound(MathAbs(profit) / m_Info.tickSize));
						break;
					case stInfos::ePercentage:
						szTxt = StringFormat("%.2f%%", NormalizeDouble((MathAbs(profit) / (m_Info.open ? m_Info.open : m_Info.price)) * 100, 2));
						break;
				}
				m_Info.szMsgGhost = ((m_Info.szMsgGhost == "") && (m_Info.ev != evMsgClosePositionEA) ? szTxt : m_Info.szMsgGhost);
				ObjectSetString(0, def_NameObjLabel, OBJPROP_TEXT, szTxt);
				if (StringLen(szTxt) != m_Info.sizeText)
				{
					AdjustDinamic(def_NameObjLabel, szTxt);
					m_Info.sizeText = StringLen(szTxt);
				}
			}
			_cor = (m_Info.limit >= 0 ? clrPaleGreen : clrCoral);
			switch (m_Info.ev)
			{
				case evMsgCloseTakeProfit:
					memTP = (Enabled ? memTP : profit);
					_cor = (m_Info.limit < memTP ? clrYellow : _cor);
					break;
				case evMsgCloseStopLoss:
					memSL = (Enabled ? memSL : profit);
					_cor = (m_Info.limit > memSL ? clrYellow : _cor);
					break;
				case evMsgClosePositionEA:
					_cor = (profit >= 0 ? clrPaleGreen : clrCoral);
					break;
			}
			ObjectSetInteger(0, def_NameObjLabel, OBJPROP_BGCOLOR, _cor);
		}
//+------------------------------------------------------------------+
		void DispatchMessage(const int id, const long &lparam, const double &dparam, const string &sparam)
		{
			string sz0;
			long _lparam = lparam;
			double _dparam = dparam;
			
			C_Mouse::DispatchMessage(id, lparam, dparam, sparam);
			switch (id)
			{
				case (CHARTEVENT_KEYDOWN):
					if (!TerminalInfoInteger(TERMINAL_KEYSTATE_ESCAPE)) break;
					_lparam = (long) m_Info.ticket;
					_dparam = 0;
					EventChartCustom(0, evUpdate_Position, _lparam, 0, "");
				case CHARTEVENT_CUSTOM + evMsgSetFocus:
					if ((m_Info.ticket == (ulong)(_lparam)) && ((EnumEvents)(_dparam) == m_Info.ev))
					{
						CreateGhost();
						UpdatePrice(m_Info.open, GetPositionsMouse().Position.Price);
					}else
					{
						ChartSetInteger(0, CHART_EVENT_OBJECT_DELETE, false);
						ObjectsDeleteAll(0, macro_GhostName(""));
						ChartSetInteger(0, CHART_EVENT_OBJECT_DELETE, true);
					}
					macro_LineInFocus((m_Info.ticket == (ulong)(_lparam)) && ((EnumEvents)(_dparam) == m_Info.ev));
					EventChartCustom(0, (ushort)(_dparam ? evHideMouse : evShowMouse), 0, 0, "");
					m_Info.bClick = false;
				case CHARTEVENT_CHART_CHANGE:
					ChartChange();
					break;
				case CHARTEVENT_CUSTOM + evMsgSwapViewModePosition:
					m_Info.ViewMode = (stInfos::e1)((((stInfos::e1)_dparam) + 1) & 0x03);
					EventChartCustom(0, evUpdate_Position, m_Info.ticket, 0, NULL);
					break;
				case CHARTEVENT_OBJECT_CLICK:
					sz0 = GetPositionsMouse().szObjNameClick;
					if (m_Info.bClick)
					{
						if (sz0 == def_NameBtnMove)
							EventChartCustom(0, evMsgSetFocus, m_Info.ticket, m_Info.ev, "");
						if (sz0 == def_NameBtnClose)
							EventChartCustom(0, (ushort) m_Info.ev, m_Info.ticket, m_Info.tpsl, m_Info.szSymbol);
						if (sz0 == def_NameObjLabel)
							EventChartCustom(0, evMsgSwapViewModePosition, m_Info.ticket, (double)m_Info.ViewMode, NULL);
					}
					m_Info.bClick = false;
					break;
				case CHARTEVENT_MOUSE_MOVE:
					m_Info.bClick = (CheckClick(C_Mouse::eClickLeft) ? true : m_Info.bClick);
					if (m_Info.weight > 1)
					{
						UpdateViewPort(_dparam = GetPositionsMouse().Position.Price);
						ViewValue(m_Info.limit = (m_Info.bIsBuy ? _dparam - m_Info.open : m_Info.open - _dparam));
						if (m_Info.bClick)
						{
							if ((m_Info.ev == evMsgCloseTakeProfit) || (m_Info.ev == evMsgCloseStopLoss))
								EventChartCustom(0, (ushort)(m_Info.ev == evMsgCloseTakeProfit ? evMsgNewTakeProfit : evMsgNewStopLoss), m_Info.ticket, GetPositionsMouse().Position.Price, m_Info.szSymbol);
							EventChartCustom(0, evMsgSetFocus, 0, 0, "");
						}
					}
					break;
				case CHARTEVENT_OBJECT_DELETE:
					if (StringFind(sparam, m_Info.szPrefixName) < 0) break;
					UpdatePrice(m_Info.open, m_Info.price);
					break;
			}
		}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
#undef def_GhostColor
#undef macro_GhostName
//+------------------------------------------------------------------+
#undef macro_LineInFocus
//+------------------------------------------------------------------+
#undef def_Btn_Close
#undef def_PathBtns
#undef def_FontName
#undef def_FontSize
//+------------------------------------------------------------------+
#undef def_NameVolume
#undef def_NameBackGround
#undef def_NameObjLabel
#undef def_NameInfoDirect
#undef def_NameBtnMove
#undef def_NameBtnClose
#undef def_NameHLine
//+------------------------------------------------------------------+